#include <stdio.h>
#include <stdlib.h>

typedef long long ll;

int cmp(const void *a, const void *b) {
    ll x = *(ll*)a;
    ll y = *(ll*)b;
    if (x < y) return -1;
    if (x > y) return 1;
    return 0;
}

ll prebroj_parove(ll *a, int n) {
    qsort(a, n, sizeof(ll), cmp);

    ll res = 0;
    for (int i = 0; i < n; ) {
        int j = i;
        while (j < n && a[j] == a[i]) j++;
        ll k = j - i;
        res += k * (k - 1) / 2;
        i = j;
    }
    return res;
}

int main() {
    int N;
    scanf("%d", &N);

    ll *x = malloc(N * sizeof(ll));
    ll *y = malloc(N * sizeof(ll));
    ll *pom = malloc(N * sizeof(ll));

    for (int i = 0; i < N; i++) {
        scanf("%lld %lld", &x[i], &y[i]);
    }

    ll odgovor = 0;

    // isti x
    for (int i = 0; i < N; i++)
        pom[i] = x[i];
    odgovor += prebroj_parove(pom, N);

    // isti y
    for (int i = 0; i < N; i++)
        pom[i] = y[i];
    odgovor += prebroj_parove(pom, N);

    // isti x - y
    for (int i = 0; i < N; i++)
        pom[i] = x[i] - y[i];
    odgovor += prebroj_parove(pom, N);

    // isti x + y
    for (int i = 0; i < N; i++)
        pom[i] = x[i] + y[i];
    odgovor += prebroj_parove(pom, N);

    printf("%lld\n", odgovor);

    free(x);
    free(y);
    free(pom);

    return 0;
}